using System;
using System.IO;

public class Program
{
  public static void Main(String[] args)
  {
    if(args.Length < 1)
    {
      Console.WriteLine("Wywołanie programu: Program plik");
      return;
    }
    String plik = args[0];

    StreamWriter sw;
    try
    {
      sw = new StreamWriter(plik);
    }
    catch(Exception)
    {
      Console.WriteLine(
        "Otwarcie pliku {0} nie powiodło się.", plik);
      return;
    }

    Console.WriteLine(
      "Wprowadzaj wiersze tekstu. Aby zakończyć, wpisz 'quit'.");
    String line;
    try
    {
      do
      {
        line = Console.ReadLine();
        sw.WriteLine(line);
      }
      while(line != "quit");
      sw.Close();
    }
    catch(Exception)
    {
      Console.WriteLine(
        "Wystąpił błąd podczas zapisu do pliku {0}.", plik);
      return;
    }
  }
}
